Attribute VB_Name = "modSpecialFolders"
Option Explicit

Private Declare Function SHGetSpecialFolderLocation Lib "shell32" (ByVal hwnd As Long, ByVal nFolder As Long, ppidl As Long) As Long
Private Declare Function SHGetPathFromIDList Lib "shell32" Alias "SHGetPathFromIDListA" (ByVal Pidl As Long, ByVal pszPath As String) As Long
Private Declare Sub CoTaskMemFree Lib "ole32" (ByVal pvoid As Long)
Private Const CSIDL_PERSONAL = &H5
Private Const CSIDL_APPDATA = &H1A
Private Const CSIDL_DESKTOPDIRECTORY = &H10
Private Const MAX_PATH = 260
Private Const NOERROR = 0

Private Function SpecFolder(ByVal lngFolder As Long) As String
    On Error GoTo hErr
    Dim lngPidlFound As Long
    Dim lngFolderFound As Long
    Dim lngPidl As Long
    Dim strPath As String
    
    strPath = Space(MAX_PATH)
    lngPidlFound = SHGetSpecialFolderLocation(0, lngFolder, lngPidl)
    If lngPidlFound = NOERROR Then
        lngFolderFound = SHGetPathFromIDList(lngPidl, strPath)
        If lngFolderFound Then
            SpecFolder = Left$(strPath, InStr(1, strPath, vbNullChar) - 1)
        End If
    End If
    CoTaskMemFree lngPidl
    Exit Function
hErr:
    ErrorHandler "SpecialFolders", "SpecFolder"
End Function

Public Function AppData() As String
    On Error GoTo hErr
    AppData = SpecFolder(CSIDL_APPDATA) & "\MirageBot\"
    Exit Function
hErr:
    ErrorHandler "SpecialFolders", "AppData"
End Function
